// Jasmine Unit Testing Suite
define([
    'backbone',
    'models/resource-model',
],
function (Backbone, Resource) {
    'use strict';

    describe('Resource Model', function () {
        var resource;

        beforeEach(function () {
            resource = new Resource({
                'title': 'patient',
                'href': '/PatientViewerServices/rest/patient/{assigning-authority}/{patient-id}',
            });
        });

        it('can formatHref()', function () {
            expect(resource.formatHref({
                'assigning-authority': 'dfn-1234',
                'patient-id': '1111',
            })).toBe('/PatientViewerServices/rest/patient/dfn-1234/1111');
        });
    });
});
